package com.ethon.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;
import javax.swing.UnsupportedLookAndFeelException;

import com.ethon.DataBase;
import com.ethon.io.DataReader;
import com.ethon.mode.DataPoint;
import com.ethon.plugin.Hasta;
import com.ethon.plugin.SNC;
import com.ethon.plugin.SNC2;
import com.ethon.tools.CoordTransfer;
import com.ethon.tools.ImageGenerator;

public class DataField extends JFrame {
	private static final long serialVersionUID = 1L;

	private static ImagePanel ipanel;
	static BufferedImage tempImg;

	public DataField() {
		// UI--START
		String ui = UIManager.getSystemLookAndFeelClassName();
		LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
		for (LookAndFeelInfo lk : info) {
			if (lk.getName().equals("Nimbus")) {
				ui = lk.getClassName();
				break;
			}
		}
		try {
			UIManager.setLookAndFeel(ui);
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (UnsupportedLookAndFeelException e) {
			e.printStackTrace();
		}
		// UI--END

		// ò˵--START
		MenuBar mb = new MenuBar();
		setJMenuBar(mb);
		// ò˵--END

		// ôڴСλ--START
		Dimension dim = getToolkit().getScreenSize();
		int sw = (int) dim.getWidth() / 9;
		int sh = (int) dim.getHeight() / 9;
		setLocation(sw, sh);
		setSize(sw * 7, sh * 7);
		// ôڴСλ--END

		int len = CoordTransfer.getLenOfImagePanel(this);
		tempImg = ImageGenerator.drawImage(null, len);

		// ʾ--START
		ipanel = new ImagePanel(DataField.this);
		add(ipanel);
		// ʾ--END

		setTitle("ݳʾϵͳ");
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setLocationRelativeTo(null);
	}

	/**
	 * ڵĲ˵
	 * 
	 * @author Alex
	 * 
	 */
	class MenuBar extends JMenuBar {
		private static final long serialVersionUID = 1L;

		MenuBar() {
			JMenu menu1 = new JMenu("ļ");
			JMenuItem item11 = new JMenuItem("");
			item11.addActionListener(new FileOpenListener());
			JMenuItem item12 = new JMenuItem("˳");
			item12.addActionListener(new ExitListener());

			JMenu menu2 = new JMenu("");
			JMenuItem item21 = new JMenuItem("SNC 㷨");
			item21.addActionListener(new SNCListener());
			JMenuItem item22 = new JMenuItem("SNC 2.0");
			item22.addActionListener(new SNC2Listener());
			JMenuItem item23 = new JMenuItem("Ľ㷨");
			item23.addActionListener(new SECSNClusterListener());

			menu1.add(item11);
			menu1.add(item12);

			menu2.add(item21);
			menu2.add(item22);
			menu2.add(item23);

			add(menu1);
			add(menu2);
		}
	}

	/**
	 * ˢ´ͼ
	 * 
	 * @param image
	 */
	public static void updateImagePanel(BufferedImage image) {
		tempImg = image;
		ipanel.update(image);
	}

	public static BufferedImage getImage() {
		return tempImg;
	}

	/**
	 * ݳ
	 */
	public void resetDataField() {

	}

	/**
	 * ȡļ
	 * 
	 * @author ethonchan@gmail.com
	 * 
	 */
	class FileOpenListener implements ActionListener {
		public void actionPerformed(ActionEvent arg0) {
			JFileChooser jfc = new JFileChooser();
			int value = jfc.showOpenDialog(DataField.this);
			if (value == JFileChooser.APPROVE_OPTION) {
				resetDataField();
				DataReader reader = new DataReader();
				File file = jfc.getSelectedFile();
				DataField.this.setTitle("ݳʾ--" + file.getName());
				DataBase.getInstance().clear();
				DataPoint[] points = reader.getDataPoints(file, 0);// ȡ

				CoordTransfer ctf = new CoordTransfer();
				int len = CoordTransfer.getLenOfImagePanel(DataField.this);
				ctf.initCoord(points, len);

				BufferedImage image = ImageGenerator.drawImage(null, len);
				image = ImageGenerator.show_DataPoints_on_Image(points, image);
				updateImagePanel(image);
			}

		}
	}

	/**
	 * ˳
	 * 
	 * @author ethonchan@gmail.com
	 * 
	 */
	private class ExitListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			System.exit(0);
		}
	}

	/**
	 * Spatial Neighborhood cluster㷨
	 * 
	 * @author ethonchan@gmail.com
	 * 
	 */
	class SNCListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			int num = 10;
			String xStr = JOptionPane.showInputDialog(DataField.this,
					"뻮", "10");
			if (xStr != null)
				num = Integer.parseInt(xStr.replaceAll("\\D", ""));

			SNC snc=new SNC(num);
			snc.process();
		}
	}

	/**
	 * Spatial Neighborhood Cluster 2.0 㷨
	 * 
	 * @author ethonchan@gmail.com
	 * 
	 */

	class SNC2Listener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			int K=15;
			String xStr = JOptionPane.showInputDialog(DataField.this,
					"ÿϻ", "15");
			if (xStr != null)
				K = Integer.parseInt(xStr.replaceAll("\\D", ""));

			SNC2 snc2=new SNC2(DataField.this,K);
			snc2.process();
		}
	}

	/**
	 * ĽSpatial Distance Cluster㷨
	 * 
	 * @author ethonchan@gmail.com
	 * 
	 */

	class SECSNClusterListener implements ActionListener {
		public void actionPerformed(ActionEvent arg0) {
			// // TODO Auto-generated method stub
			// SpatialDistanceClusterSec sdc = new SpatialDistanceClusterSec();
			// sdc.process();

			// NewMethodĲ
			String input = JOptionPane.showInputDialog("");
			if (input == null)
				return;
			int K = Integer.parseInt(input.trim());
			
//			input = JOptionPane.showInputDialog("ֵ");
//			if (input == null)
//				return;
//			int thread = Integer.parseInt(input.trim());
			
			input = JOptionPane.showInputDialog("ÿı߰С");
			if (input == null)
				return;
			int stepParam=Integer.parseInt(input.trim());
			
			Hasta nm=new Hasta(K,stepParam);
			nm.process();
			
//			SNewMethod nm=new SNewMethod(K,thread);
//			nm.process();
			
		}

	}
}
